#pragma once
#include "Camera.h"
class SelfRotatingCamera : public Camera
{

public:
	enum RotationAxis
	{
		Y
		//Could add other axis's here in the future if needed
	};

	SelfRotatingCamera(Vector3 origin, Vector3 pitchYawRoll, RotationAxis rotAxis, float min, float max, int pauseBoundsDur = 2);	//Initial position, initial pitch, yaw and roll, axis of rotation, min rot axis value, min rot axis value, pause duration
	SelfRotatingCamera(Vector3 origin, Vector3 pitchYawRoll, float rotSpeed, RotationAxis rotAxis, float min, float max, int pauseBoundsDur = 2);	//Initial position, initial pitch, yaw and roll, speed of rotation, axis of rotation, min rot axis value, min rot axis value, pause duration
	~SelfRotatingCamera();

	//Overrides - as SelfRotatingCamera is procedurally controlled, we do nothing based on user input, so these are empty
	void Animate(float dt) override;
	void MoveForward(float dt) override;
	void MoveRight(float dt) override;
	void MoveUp(float dt) override;
	void RotateX(float dt) override;
	void RotateY(float dt) override;
	void RotateZ(float dt) override;
	void RotateFromMouse(float xOffset, float yOffset, float dt) override;

private:
	RotationAxis _RotationAxis;	//Axis upon which we're rotating
	float _MinimumRot;		//Minimum axis value	//
	float _MaximumRot;	//Maximum axis value		//		These define the range of motion of the camera
	int _PauseBoundsDuration;	//How long the camera should pause at its min or max before beginning to rotate in the opposite direction
	float _TimePaused;	//How long the motion has been paused
	bool _IsPaused;	//Is the motion paused?
};

